package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: RepeatLunchTypeInScenesEnum <br/>
 * Function: 不同的重复过滤发券场景. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public enum RepeatLunchTypeInScenesEnum {
    /** 资源标签分平台过滤 */
    RESOURCE(1, "资源标签分平台过滤"),

    /** 行业标签分媒体过滤 */
    TRADE_APP(2, "行业标签分媒体过滤");

    private String desc;

    private Integer code;

    RepeatLunchTypeInScenesEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, RepeatLunchTypeInScenesEnum> enumMap = Maps.newHashMap();
    static {
        for (RepeatLunchTypeInScenesEnum it : RepeatLunchTypeInScenesEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static RepeatLunchTypeInScenesEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
