package cn.com.tuia.advert.enums;

/**
 * @author zhangmeng
 * @date 2019/5/18
 * @function 潜力广告枚举类
 */
public enum PotentionalAdvertEnum {

    NO_POTENTIONAL_ADVERT(0,"普通广告配置"),

    OPENING_POTENTIONAL_ADVERT(1,"开启的潜力广告配置"),

    CLOSED_POTENTIONAL_ADVERT(2,"关闭的潜力广告配置"),

    CLOSED_OVER_POTENTIONAL_ADVERT(3,"测试足量或者到期潜力广告配置")
    ;

    PotentionalAdvertEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static PotentionalAdvertEnum getByCode(Integer code){

        for(PotentionalAdvertEnum potentionalAdvertEnum:PotentionalAdvertEnum.values()){
            if(potentionalAdvertEnum.getCode().equals(code)){
                return potentionalAdvertEnum;
            }
        }
        return null;
    }

    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
