package cn.com.tuia.advert.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 域名处理工具类
 * copy from tuia-ac-web
 *
 * @author chengdeman
 * @create 2017-06-27 上午9:46
 **/
public class DomainUtil {

    private DomainUtil() {}

    /**
     * 判断是否是积木的落地页
     *
     * @param promoteUrl 落地页链接
     * @return 是否积木的落地页
     */
    public static boolean isJimuDomain(String promoteUrl) {
        if (StringUtils.isBlank(promoteUrl)) {
            return false;
        }

        String jimuDomainStr = "/render?id=";

        // 不包含积木字符，返回false
        if(!promoteUrl.contains(jimuDomainStr)){
            return false;
        }

        int index = promoteUrl.indexOf(jimuDomainStr);
        // 之后的字符串
        String restUrl = promoteUrl.substring(index + jimuDomainStr.length());

        int lastIndex = restUrl.length();
        if(restUrl.contains("&")){
            lastIndex = restUrl.indexOf("&");
        }

        String landPageIdStr = restUrl.substring(0, lastIndex);
        String landPageId = Base64Util.decode(landPageIdStr + "==");

        return StringUtils.isNotBlank(landPageId) && StringUtils.isNumeric(landPageId);
    }

    /**
     * 是否是百奇域名，判断当前落地页地址是不是百奇的落地页
     *
     * 同时包含 /item/detail和id=    广告计划的落地页标签为“货到付款”或“货到付款（百奇）”
     * 存在风险，如果其他非百奇的落地页也同时包含这两个字符串的话，可能会出现落地页打不开的情况
     * 风险已同步给产品 @柳军强
     *
     * @param promoteUrl 落地页链接
     * @return 是否百奇的落地页
     */
    public static boolean isBaiqiDomain(String promoteUrl) {
        if (StringUtils.isBlank(promoteUrl)) {
            return false;
        }

        String baiqiDomainStr = "/item/detail";
        String baiqiDomainStr2 = "id=";
        String baiqiDomainStr3 = "collection/index?collId=";
        //是否同时包含 /item/detail和id=
        boolean condition1=promoteUrl.contains(baiqiDomainStr) && promoteUrl.contains(baiqiDomainStr2);
        //同时包含 /item/detail和id=    或包含【collection/index?collId=】字符
        return condition1 || promoteUrl.contains(baiqiDomainStr3);
    }
}
