package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息触达用户后，用户的行为
 *
 * @author chengsiyi
 * @date 2020/8/14 10:22
 */
public enum UserBehaviorEnum {
    /**
     * 用户主要行为
     */
    REFUSE_RECEIVE("410", "拒绝接收"),
    INDEX("411", "访问"),
    JOIN("412", "参与"),
    MSG_PUSH("413", "消息发送"),
    CONSUMER_MSG_PUSH("414", "客服消息推送");


    String code;
    String desc;

    UserBehaviorEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    private static final Map<String, UserBehaviorEnum> ENUM_MAP = new HashMap<>();

    static {
        for (UserBehaviorEnum behaviorEnum : values()) {
            ENUM_MAP.put(behaviorEnum.getCode(), behaviorEnum);
        }
    }

    public static UserBehaviorEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
