package cn.com.duiba.wechat.server.api.enums;

/**
 * 短信验证码限制策略类型
 *
 * @author fxr
 * @date 2021/01/28
 */
public enum VerifyCodeLimitTypeEnum {
    MOBILE_LIMIT_EVERY_MINUTE(1, 2000015, "同一手机号码每分钟获取上限"),
    IP_LIMIT_EVERY_MINUTE(2, 2000016, "同一IP每分钟获取上限"),
    MOBILE_LIMIT_DAILY(3, 2000017, "同一手机号码每日获取上限");


    /**
     * 业务码
     */
    Integer bizCode;
    /**
     * 错误码
     *
     * @see ErrorCode#getErrorCode
     */
    Integer errCode;
    /**
     * 错误描述
     */
    String errMsg;

    private VerifyCodeLimitTypeEnum(Integer bizCode, Integer errCode, String errMsg) {
        this.bizCode = bizCode;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public Integer getBizCode() {
        return bizCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public Integer getErrCode() {
        return errCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }
}
