package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.BaseHzBankUserInfoDto;
import cn.com.duiba.wechat.server.api.dto.JibuLoginUserInfoDto;

/**
 * @author haojiahong
 * @date 2021-01-18
 */
@AdvancedFeignClient
public interface RemoteJibuCustomService {

    /**
     * 通过openId查询用户信息
     *
     * @param openId
     * @return
     */
    JibuLoginUserInfoDto getUserInfoByOpenId(String openId);


    /**
     * 保存用户信息
     *
     * @param userInfoDto
     */
    void saveOrUpdateUserInfo(JibuLoginUserInfoDto userInfoDto);


    /**************************以下两个接口为集步2.0版本*****************************/

    /**
     * 集步登陆2.0版本
     * 通过用户openId和channel查询用户信息
     *
     * @param openId
     * @param channel
     * @return
     */
    BaseHzBankUserInfoDto getUserInfoByOpenIdAndChannel(String openId, String channel);

    /**
     * 集步登陆2.0版本
     * 更新用户信息(openId channel必传)
     *
     * @param baseHzBankUserInfoDto
     */
    void updateUserInfoByOpenIdAndChannel(BaseHzBankUserInfoDto baseHzBankUserInfoDto);

}
