package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WxSceneIdGenParam;
import cn.com.duiba.wechat.server.api.dto.WxSceneRecordDto;

/**
 * created by liugq in 2019/07/03
 */
@AdvancedFeignClient
public interface RemoteWxSceneRecordService {

    /**
     * 分享时初始化分享数据，用于生成带参二维码
     * @param param
     * @return 返回senceid
     */
    @Deprecated
    Long getSenceId(WxSceneIdGenParam param) throws BizException;

    /**
     * 获取场景值
     * 分享时初始化分享数据，用于生成带参二维码
     *
     * ps：与上面的接口只是改动了接口名
     * @param param 请求参数，
     *              其中 {@link WxSceneIdGenParam#consumerId} 和 {@link WxSceneIdGenParam#shareKey}必须为同一个用户的信息
     *              {@link WxSceneIdGenParam#actId} 为Long，若有其他类型的数据，需要调用方自行转换成Long 保证唯一
     * @return 场景值
     * @throws BizException
     */
    Long getSceneId(WxSceneIdGenParam param) throws BizException;

    /**
     * 获取带参二维码内容，用于自己生成二维码
     *
     * @param sceneId 场景值
     * @return 带参二维码内容
     * @throws BizException 业务异常
     */
    String getSceneQrCodeContent(Long sceneId) throws BizException;

    /**
     * 获取带参二维码ticket，是调用微信接口获取二维码的凭证
     * <p>
     * HTTP GET请求（请使用https协议）https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=TICKET
     * 提醒：TICKET记得进行UrlEncode
     *
     * @param sceneId 场景值
     * @return 带参二维码ticket
     * @throws BizException 业务异常
     */
    String getSceneQrCodeTicket(Long sceneId) throws BizException;

    /**
     * 根据场景码获取实体类
     *
     * @param sceneId 场景值
     * @return 实体类
     * @throws BizException 业务异常
     */
    WxSceneRecordDto getBySceneId(Long sceneId) throws BizException;
}
