package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WxMiniUserInfoDto;
import cn.com.duiba.wechat.server.api.param.WxMiniAppSendMsgParam;

/**
 * @program: wechat-server
 * @description: 微信小程序
 * @author: fenghuohuo
 * @create: 2021-09-08 10:07
 **/
@AdvancedFeignClient
public interface RemoteWxMiniService {

    /**
     * 微信小程序获取用户信息
     *
     * @param sessionKey
     * @param signature
     * @param rawData
     * @param encryptedData
     * @param iv
     * @param appKey
     * @param isBindUnionId 是否使用unionId作为uid
     * @return
     */
    WxMiniUserInfoDto getUserInfo(String sessionKey, String signature, String rawData, String encryptedData, String iv, String appKey, Boolean isBindUnionId)
        throws BizException;

    /**
     * 微信小程序推送消息（单条）
     * @param param
     */
    void sendMessage(WxMiniAppSendMsgParam param);
}
