package cn.com.duiba.custom.biz.common;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.wechat.server.api.param.ContextContent;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author 刘凯
 * @Date 2022/7/26 6:20 下午 （可以根据需要修改）
 * @Version 1.0 （版本号）
 */

@Component
public class CustomLoginHanderImpl implements CustomLoginHander {

    /**
     * @param request
     * @param app
     * @param contextContent 透传参数
     * @return
     * @throws BizException
     */
    @Override
    public LoginResult customLoginHander(HttpServletRequest request, AppSimpleDto app, ContextContent contextContent) throws BizException {

        CustomLoginHanderService customLoginHanderService = CustomLoginRegistry.PROVIDER_MAP.get(app.getId());

        if (customLoginHanderService == null) {
            LoginResult loginResult = new LoginResult();
            loginResult.setSkip(true);
            return loginResult;
        }

        return customLoginHanderService.getRedirectUrl(request, app, contextContent);

    }


}
