package cn.com.duiba.custom.biz.common;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: liukai
 * @Date: 2022/7/26 19:38
 */
public class CustomLoginRegistry {

    protected static final Map<Long, CustomLoginHanderService> PROVIDER_MAP = new HashMap<>();

    private CustomLoginRegistry() {
    }

    public static void register(Long appId, CustomLoginHanderService customLoginHanderService) {
        PROVIDER_MAP.put(appId, customLoginHanderService);
    }

    public static CustomLoginHanderService get(Long appId) {
        return PROVIDER_MAP.get(appId);
    }
}
