package cn.com.duiba.custom.biz.guangxipostal;

import cn.com.duiba.custom.biz.common.CustomLoginHanderService;
import cn.com.duiba.custom.biz.common.CustomLoginRegistry;
import cn.com.duiba.custom.biz.common.LoginResult;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.wechat.server.api.param.ContextContent;

import cn.com.duiba.custom.biz.guangxipostal.config.GxycConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/**
 * @Author 刘凯
 * @Date 2022/8/4 11:06 上午 （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@Service
public class GuangxiPostal implements CustomLoginHanderService {

    private static final Logger logger = LoggerFactory.getLogger(GuangxiPostal.class);


    private static final String REDIRECT = "redirect:";

    @Autowired
    private GxycConfig gxycConfig;


    /**
     * 广西邮储 -- dbredirect校验域名
     * @param request
     * @param app
     * @param contextContent
     * @return
     */
    @Override
    public LoginResult getRedirectUrl(HttpServletRequest request, AppSimpleDto app, ContextContent contextContent) {
        LoginResult loginResult = new LoginResult();
        String dbredirect = request.getParameter("dbredirect");
        List<String> domainList;
        if (StringUtils.isNotBlank(dbredirect) && (domainList = gxycConfig.getDomainList(app.getId())) != null) {
            URL url = null;
            try {
                url = new URL(dbredirect);
            } catch (MalformedURLException e) {
                logger.info("dbredirect:[{}]命中非白名单域名,无法转换为url",dbredirect);
                loginResult.setRedirectUrl(getErrRedirect(String.valueOf(contextContent.getData().get("host"))));
                return loginResult;
            }
            String host = url.getHost();
            boolean safe = false;
            for (String domain : domainList) {
                if (host.contains(domain)) {
                    safe = true;
                    break;
                }
            }
            if (!safe) {
                logger.info("dbredirect:[{}]命中非白名单域名",dbredirect);
                loginResult.setRedirectUrl(getErrRedirect(String.valueOf(contextContent.getData().get("host"))));
                return loginResult;
            }
        }
        loginResult.setSkip(true);
        return loginResult;
    }

    private String getErrRedirect(String host) {
        return REDIRECT + host + "/err";
    }


    @Override
    public List<Long> getAppIds() {
        return gxycConfig.getAppIds();
    }

    @PostConstruct
    public void init() {
        for (Long appId : getAppIds()) {
            CustomLoginRegistry.register(appId, this);
        }
    }
}
