package cn.com.duiba.custom.biz.guangxipostal.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 广西邮储--增加域名校验
 * 可通用
 */
@Configuration
@ConfigurationProperties(prefix = "gxyc.config")
public class GxycConfig implements InitializingBean {

    private static final Logger logger = LoggerFactory.getLogger(GxycConfig.class);

    private String safeDomain = "\t{\"1986\":[\"m.duibatest.com.cn\"]}";

    private Map<Long, List<String>> safeDomainMap;

    private List<Long> appIds;

    public String getSafeDomain() {
        return safeDomain;
    }

    public void setSafeDomain(String safeDomain) {
        this.safeDomain = safeDomain;
    }

    public Map<Long, List<String>> getSafeDomainMap() {
        return safeDomainMap;
    }

    public void setSafeDomainMap(Map<Long, List<String>> safeDomainMap) {
        this.safeDomainMap = safeDomainMap;
    }

    public List<String> getDomainList(Long appId) {
        if (this.safeDomainMap == null) {
            return null;
        }
        return this.safeDomainMap.get(appId);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.safeDomainMap = new HashMap<>();
        try {
            JSONObject jsonObject = JSON.parseObject(safeDomain);
            for (String key : jsonObject.keySet()) {
                safeDomainMap.put(Long.parseLong(key), JSON.parseArray(jsonObject.getString(key), String.class));
            }
            appIds = Lists.newArrayList(safeDomainMap.keySet());
            logger.info("广西邮储 安全域名配置刷新:{}", safeDomainMap);
        } catch (Exception e) {
            logger.warn("广西邮储 安全域名配置项解析出错:{}", safeDomain, e);
        }
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }
}
