package cn.com.duiba.custom.biz.jiujiuya.impl;


import cn.com.duiba.consumer.center.api.dto.ConsumerDto;
import cn.com.duiba.custom.biz.jiujiuya.config.JiujiuCustomConfig;
import cn.com.duiba.wechat.server.api.util.HttpUtil;
import cn.com.duiba.wechat.server.api.util.MD5;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import cn.com.duiba.custom.biz.jiujiuya.JjyService;
import cn.com.duiba.custom.biz.jiujiuya.bean.JJYUserBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2019/7/30
 */
@Component
public class JjyServiceImpl implements JjyService {

    private static final Logger LOGGER = LoggerFactory.getLogger(JjyServiceImpl.class);

    //已到门点消费过的等级标识
    private static final String MARK_OLD = "0";
    //未到门店消费过的等级标识
    private static final String MARK_NEW = "1";
    //接口成功代码
    private static final String CODE_SUCCESS = "1";

    @Autowired
    private JiujiuCustomConfig customConfig;

    /**
     *  兑吧app在久久丫/留夫鸭平台的appid
     */
    private static Map<String, String> codeAppIdMaps = new ImmutableMap.Builder<String, String>()
            .put("310117", "$1$UZlOGk6B$/2X97agCaZOkGzgqXF4.R1")
            .put("6543", "$1$oyfHoWps$3euCg.HlWrGHoqVKG/8050")
            .build();

    /**
     * 兑吧app在久久丫/留夫鸭平台的secret
     */
    private static Map<String, String> codeSecrets = new ImmutableMap.Builder<String, String>()
            .put("310117", "$1$u5dzVzFY$BOi6AE87LPpXONj099JJ11")
            .put("6543", "$1$kYGw9ATM$EcLzJLvHPcuzmBfrz8KCI0")
            .build();

    /**
     * 久久丫平台的访问地址
     */
    private static final String URL = "http://openapi.bigaka.com/wx-api/newOpenApi";

    /**
     * 久久丫微信公众号的appKeys集合
     */
    private static final ImmutableSet<String> SPECIAL_APP_KEYS =
            ImmutableSet.of("3LEw7TTZnX9deHyURuswTBYHxkS9", "54eF9erSp6dqwkJ4wi1bWTnPYsk","4UWGLg3RMPKStmVSA2QRgh4DPmye");

    public static ImmutableSet<String> getSpecialAppKeys() {
        return SPECIAL_APP_KEYS;
    }

    @Autowired
    private JiujiuCustomConfig jiujiuConfig;

    @Override
    public JJYUserBean getUserInfo(String storeCode, String openId, String appKey) {
        if (!codeAppIdMaps.containsKey(storeCode)) {
            LOGGER.info("当前storeCode未对接,storeCode={}", storeCode);
            return null;
        }
        if (jiujiuConfig.getJjyNewUrlApks().contains(appKey)) {
            return getUserInfoRequest(storeCode, openId);
        }
        String appId = codeAppIdMaps.get(storeCode);
        String secret = codeSecrets.get(storeCode);
        String ts = DateUtils.getMillisecond().substring(0,14);
        MsgInfo msgInfo = new MsgInfo();
        msgInfo.setOpenId(openId);
        String msg = JSON.toJSONString(msgInfo);
        String sign = MD5.md5EncryptTo32(appId+secret+ts+msg).toLowerCase();
        String result;

        HttpPost httpPost = new HttpPost(URL);
        try {
            httpPost.setHeader("app_id", appId);
            httpPost.setHeader("secret", secret);
            httpPost.setHeader("ts", ts);
            httpPost.setHeader("sign", sign);
            httpPost.setHeader("model", "customer");
            httpPost.setHeader("store_code", storeCode);
            httpPost.setHeader("method", "get");
            httpPost.setHeader("Content-Type", "application/json");
            result = HttpUtil.doPostSSLWithHead(httpPost, msg);
        } catch (Exception e) {
            LOGGER.error("[JJYServiceImpl.getUserInfo]调用久久丫接口失败，请求{}", JSON.toJSONString(httpPost.getAllHeaders()), e);
            return null;
        }

        if (result == null) {
            return null;
        }

        JSONObject jsonObject = JSON.parseObject(result);
        if (jsonObject == null){
            return null;
        }
        String code = jsonObject.getString("code");
        if ("0".equals(code)) {
            LOGGER.info("调用久久丫接口查询用户不存在:{},请求{}", result, JSON.toJSONString(httpPost.getAllHeaders()));
            //后期可走注册用户逻辑
            return new JJYUserBean();
        }
        if (!"1".equals(code)) {
            LOGGER.info("调用久久丫接口查询用户失败:{},请求{}", result, JSON.toJSONString(httpPost.getAllHeaders()));
            return null;
        }
        String successResult = jsonObject.getString("result");
        return JSON.toJavaObject(JSON.parseObject(successResult), JJYUserBean.class);
    }


    @Override
    public String getUserMark(String storeCode, long mobile, String uid, String appKey) {
        if (!codeAppIdMaps.containsKey(storeCode)) {
            LOGGER.info("当前storeCode未对接,storeCode={}", storeCode);
            return MARK_OLD;
        }
        if (ConsumerDto.NOTLOGINUSERID.equals(uid)) {
            return MARK_OLD;
        }
        //手机号为0默认为新用户
        if (mobile == 0L) {
            return MARK_NEW;
        }
        if (jiujiuConfig.getJjyNewUrlApks().contains(appKey)) {
            return getOfflineOrderRequest(storeCode, String.valueOf(mobile));
        }
        String appId = codeAppIdMaps.get(storeCode);
        String secret = codeSecrets.get(storeCode);
        String ts = DateUtils.getMillisecond().substring(0, 14);
        JSONObject param = new JSONObject();
        param.put("mobile", String.valueOf(mobile));
        param.put("page_no", 1);
        param.put("page_size", 1);
        String msg = param.toJSONString();
        String sign = MD5.md5EncryptTo32(appId + secret + ts + msg).toLowerCase();
        String result;
        HttpPost httpPost = new HttpPost(URL);

        try {
            httpPost.setHeader("app_id", appId);
            httpPost.setHeader("secret", secret);
            httpPost.setHeader("ts", ts);
            httpPost.setHeader("sign", sign);
            httpPost.setHeader("model", "order");
            httpPost.setHeader("store_code", storeCode);
            httpPost.setHeader("method", "getOfflineOrders");
            httpPost.setHeader("Content-Type", "application/json");
            result = HttpUtil.doPostSSLWithHead(httpPost, msg);
        } catch (Exception e) {
            LOGGER.error("调用久久丫线下订单查询接口失败,请求{}", JSON.toJSONString(httpPost.getAllHeaders()), e);
            return MARK_OLD;
        }

        if (StringUtils.isBlank(result)) {
            return MARK_OLD;
        }

        JSONObject jsonObject = JSON.parseObject(result);
        String code = jsonObject.getString("code");
        if (!CODE_SUCCESS.equals(code)) {
            LOGGER.info("调用久久丫线下订单查询接口失败:{},请求{}", result, JSON.toJSONString(httpPost.getAllHeaders()));
            return MARK_OLD;
        }
        JSONObject data = jsonObject.getJSONObject("result");
        //已消费过则标记为老用户
        if (data.getIntValue("total") > 0) {
            return MARK_OLD;
        }
        return MARK_NEW;
    }

    private JJYUserBean getUserInfoRequest(String storeCode, String openId) {
        TreeMap<String, String> params = new TreeMap<>();
        params.put("open_id", openId);
        params.put("third_party_type", "1");
        params.put("store_code", storeCode);
        String result = doRequest(storeCode, "get", "customer", params);
        if (result == null) {
            return null;
        }

        JSONObject jsonObject = JSON.parseObject(result);
        if (jsonObject == null) {
            return null;
        }
        String code = jsonObject.getString("code");
        if ("0".equals(code)) {
            LOGGER.info("调用久久丫接口查询用户不存在:{},请求{}", result, JSON.toJSONString(params));
            //后期可走注册用户逻辑
            return new JJYUserBean();
        }
        if (!"1".equals(code)) {
            LOGGER.info("调用久久丫接口查询用户失败:{},请求{}", result, JSON.toJSONString(params));
            return null;
        }
        String successResult = jsonObject.getString("result");
        return JSON.toJavaObject(JSON.parseObject(successResult), JJYUserBean.class);
    }


    private String getOfflineOrderRequest(String storeCode, String mobile) {
        TreeMap<String, String> params = new TreeMap<>();
        params.put("mobile", mobile);
        params.put("page_no", "1");
        params.put("page_size", "1");
        String result = doRequest(storeCode, "getOfflineOrders", "order", params);
        if (StringUtils.isBlank(result)) {
            return MARK_OLD;
        }

        JSONObject jsonObject = JSON.parseObject(result);
        String code = jsonObject.getString("code");
        if (!CODE_SUCCESS.equals(code)) {
            LOGGER.info("调用久久丫线下订单查询接口失败:{},请求{}", result, JSON.toJSONString(params));
            return MARK_OLD;
        }
        JSONObject data = jsonObject.getJSONObject("result");
        //已消费过则标记为老用户
        if (data.getIntValue("total") > 0) {
            return MARK_OLD;
        }
        return MARK_NEW;
    }

    private String doRequest(String storeCode, String methodName, String model, TreeMap<String, String> params) {

        String appId = customConfig.getJjyAppId();
        String secret = customConfig.getJjySecret();
        String ts = DateUtils.getMillisecond().substring(0, 14);
        String msg = JSON.toJSONString(params);
        String sign = MD5.md5EncryptTo32(appId + secret + ts + msg).toLowerCase();
        HttpPost httpPost = new HttpPost(customConfig.getJjyNewUrl());
        httpPost.setHeader("app_id", appId);
        httpPost.setHeader("ts", ts);
        httpPost.setHeader("sign", sign);
        httpPost.setHeader("model", model);
        httpPost.setHeader("store_code", storeCode);
        httpPost.setHeader("method", methodName);
        httpPost.setHeader("request-channel", "6866");
        httpPost.setHeader("Content-Type", "application/json");
        try {
            return HttpUtil.doPostSSLWithHead(httpPost, msg);
        } catch (Exception e) {
            LOGGER.error("[JJYServiceImpl.getUserInfo]调用久久丫接口失败，请求{}", JSON.toJSONString(httpPost.getAllHeaders()), e);
        }
        return null;
    }

    class MsgInfo {


        @JSONField(name = "open_id")
        private String openId;

        public String getOpenId() {
            return openId;
        }

        public void setOpenId(String openId) {
            this.openId = openId;
        }
    }
}
