package cn.com.duiba.wolf.dubbo;

import java.io.Serializable;

/**
 * Created by xuezhaoming on 16/5/5. </br>
 * dubbo 调用统一返回结果对象
 */
public class DubboResult<T> implements Serializable {

    private static final long serialVersionUID = -6978963188996203322L;

    // 调用是否成功
    private boolean           isSuccess;

    // 国际化的key，暂时不需要
    private String            i18nKey;

    // 调用结果信息
    private String            msg;

    // 调用结果
    private T                 result;

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getI18nKey() {
        return i18nKey;
    }

    public void setI18nKey(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public static void main(String[] args) {

        DubboResult<String> dubboResult = mockDubboResult();

        if (dubboResult.isSuccess()) {
            // todo
        } else {
            // todo
        }
    }

    private static DubboResult<String> mockDubboResult() {
        return new DubboResult<String>();
    }
}
