package cn.com.duiba.wolf.utils;

import sun.misc.BASE64Encoder;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * 提供加解密等方法
 * Created by wenqi.huang on 16/4/11.
 */
public class SecurityUtils {
    private static Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static String hexDigits[] = { "0", "1", "2", "3", "4", "5", "6","7", "8", "9", "a", "b", "c", "d", "e", "f" };

    /**
     * 用SHA(即SHA1)算法编码成字节数组
     * @param src
     * @return
     */
    public static byte[] encode2BytesBySHA(String src){
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");// 等同 SHA-1
            md.update(src.getBytes(DEFAULT_CHARSET));
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 用SHA算法编码成字符串
     * @param src
     * @return
     */
    public static String encode2StringBySHA(String src){
        byte[] bs = encode2BytesBySHA(src);
        return byteArrayToHexString(bs);
    }

    public static String encode2StringByBase64(byte[] bytes){
        return (new BASE64Encoder()).encode(bytes);
    }

    public static String encode2StringByMd5(String src){
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte b[] = src.getBytes(DEFAULT_CHARSET);
            md5.update(b, 0, b.length);
            return byteArrayToHexString(md5.digest());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String byteArrayToHexString(byte b[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; i++)
            sb.append(byteToHexString(b[i]));

        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}
