package cn.com.duiba.wolf.spring.datasource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import javax.sql.DataSource;
import java.lang.reflect.Method;

/**
 * Created by wenqi.huang on 16/6/3.
 */
public class TransactionUtils {

    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);

    private TransactionUtils(){}

    /**
     * 判断当前线程是否在事务中。只判断是否在事务代码包含中,无论该事务内是否操作了其他数据源的表.
     *
     * @return
     */
    public static boolean isCurrentThreadInTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    /**
     * 判断当前线程中某个数据源所绑定的Connection是否在事务中。
     * <br/>
     * <br/>由于用到了反射调用，可能下一个版本spring不支持（可能性较小）
     *
     * @param dataSource
     * @return
     */
    public static boolean isCurrentDataSourceInTransaction(DataSource dataSource) {
        ConnectionHolder conHolder = (ConnectionHolder) TransactionSynchronizationManager.getResource(dataSource);
        if (conHolder == null) {
            return false;
        }

        try {
            Method m = ConnectionHolder.class.getDeclaredMethod("isTransactionActive");
            m.setAccessible(true);
            Boolean b = (Boolean) m.invoke(conHolder);
            return b;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }
}
