package cn.com.duiba.wolf.spring.selfaware;

/**
 * 实现此接口的spring bean可以注入自身,这在某些场合非常有用.比如经过AOP的bean,实际上会创建该bean的一个代理类,如果需要在该bean的一个方法内部调用同bean内的另一个注解了注解式事务的方法,则事务不会生效.
 * 这时需要使用SelfAware注入自身（实际上注入的是经过AOP的代理类）,然后调用selfBean上的方法,就能触发事务了,可以注入接口或实现类,根据你的情况自行决定.(注入实现类的好处是可以调用一些没有在接口中没有暴露的public方法)
 * <br/>
 * 注意，使用此接口前必须在spring配置文件中配置SelfAwarePostPrecessor.
 * Created by wenqi.huang on 16/6/2.
 */
public interface SelfAware<T> {

    public void setSelf(T selfBean);

}
