package cn.com.duiba.wolf.cache;

import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface CacheClient {

    /**
     * 根据Key读取Cache中的值
     * 
     * @param key
     * @return
     */
    <T> T get(String key);

    public long getLong(String key);

    /**
     * 设置值
     * 
     * @param key
     * @param value
     * @param expSeconds 过期时间（单位：秒）
     */
    void set(String key, Object value, int expSeconds);

    /**
     * 设置值
     * 
     * @param key
     * @param value
     * @param exp
     * @param timeUnit
     */
    void set(String key, Object value, int exp, TimeUnit timeUnit);

    /**
     * 移除key
     * 
     * @param key
     * @return
     */
    void remove(String key);

    /**
     * 清空所有缓存
     */
    void flushAll();

    // /**
    // * 是否包含key
    // *
    // * @param key
    // * @return
    // */
    // boolean containsKey(String key);

    /**
     * 设置category中key，value
     * 
     * @param category
     * @param key
     * @param value
     */
    public void putAttribute(String category, String key, Object value);

    /**
     * 设置category中key，value
     * 
     * @param category
     * @param key
     * @param value
     * @param exp 过期时间（单位：秒）
     */
    public void putAttribute(String category, String key, Object value, int exp);

    public Map<String, Object> getAttribute(String category);

    public Object getAttribute(String category, String key);
    
    public void incr(String key, long by);

    public void incr(String key, long by, long exp, TimeUnit timeUnit);

    public void incr(String key, long delta, long initValue, long expiry, TimeUnit unit);

    public void decr(String key, long by);

    public void decr(String key, long by, long exp, TimeUnit timeUnit);

    public void decr(String key, long delta, long initValue, long expiry, TimeUnit unit);

}
