package cn.com.duiba.wolf.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;


/**
 * 对象工具类<BR>
 */
public class ObjectUtil {
	private static BeanUtilsBean bu;
	static {
        bu = new BeanUtilsBean(new ConvertUtilsBean(), BeanUtilsBean.getInstance().getPropertyUtils());

        bu.getConvertUtils().register(new IntegerConverter(null), Integer.class);
        bu.getConvertUtils().register(new DoubleConverter(null), Double.class);
        bu.getConvertUtils().register(new BigDecimalConverter(null), BigDecimal.class);
        bu.getConvertUtils().register(new BigIntegerConverter(null), BigInteger.class);
        bu.getConvertUtils().register(new SqlTimestampConverter(null), Timestamp.class);
        bu.getConvertUtils().register(new ShortConverter(null), Short.class);
        bu.getConvertUtils().register(new FloatConverter(null), Float.class);
        bu.getConvertUtils().register(new LongConverter(null), Long.class);
        bu.getConvertUtils().register(new ByteConverter(null), Byte.class);
        bu.getConvertUtils().register(new CharacterConverter(null), Character.class);
        bu.getConvertUtils().register(new BooleanConverter(null), Boolean.class);
        bu.getConvertUtils().register(new SqlTimeConverter(null), Time.class);
        bu.getConvertUtils().register(new SqlDateConverter(null), java.util.Date.class);
    }
	
	/**
     * Bean对象间拷贝<BR>
     * 
     * @param from 源对象
     * @param to 目的对象
     */
    public static void convert(Object from, Object to) {
        try {
            bu.copyProperties(to, from);
        } catch (Exception e) {
            
        }
    }
    
    /**
     * List对象间拷贝<BR>
     * 
     * @param from 源List
     * @param to 目的List
     * @param clazz 目的对象class
     */
    public static <T, M> void convertList(List<T> from, List<M> to, Class<M> clazz) {
        if (!to.isEmpty()) {
            to.clear();
        }
        if (from.isEmpty() || from.size() == 0) {
            return;
        }
        for (T fromItem : from) {
            M toItem = null;
            try {
                toItem = (M) clazz.newInstance();
            } catch (Exception e) {
            }

            if (toItem == null) {
                toItem = (M) fromItem;
            } else {
                convert(fromItem, toItem);
            }

            to.add(toItem);
        }
    }
}
