/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.DubboException;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.io.UnsafeStringWriter;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericService;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class RuntimeExceptionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result = invoker.invoke(invocation);
        if (result.hasException() && GenericService.class != invoker.getInterface()) {
            try {
                Throwable exception = result.getException();
                if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                    return result;
                }
                if (exception instanceof RpcException) {
                    return result;
                }
                try {
                    Class<?>[] exceptionClassses;
                    Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                    for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                        if (!exception.getClass().equals(exceptionClass)) continue;
                        return result;
                    }
                }
                catch (NoSuchMethodException e) {
                    return result;
                }
                Object[] arguments = invocation.getArguments();
                log.error(exception.getMessage() + " params : " + arguments.toString(), exception);
                return new RpcResult((Throwable)new DubboException(exception.getMessage(), this.toShortString(exception)));
            }
            catch (Throwable e) {
                return result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toShortString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        try (PrintWriter p = new PrintWriter((Writer)w);){
            this.printStackTrace(e, p, true);
            String string = w.toString();
            return string;
        }
    }

    private void printStackTrace(Throwable e, PrintWriter p, boolean isTop) {
        if (e != null) {
            if (isTop) {
                p.println(e);
            } else {
                p.println("Caused by: " + e);
            }
            StackTraceElement[] trace = e.getStackTrace();
            int i = 0;
            int lastPrintedLineNumber = 0;
            for (StackTraceElement traceElement : trace) {
                if (i < 2 || traceElement.getClassName().startsWith("cn.com.duiba")) {
                    if (lastPrintedLineNumber < i - 1) {
                        p.println("\t...");
                    }
                    p.println("\tat " + traceElement);
                    lastPrintedLineNumber = i;
                }
                ++i;
            }
            this.printStackTrace(e.getCause(), p, false);
        }
    }
}

