/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;

public final class JavaScriptUtil {
    private static final String SPECIAL_CHARACTERS = "\n\r\f'\"\\";
    private static final Properties ESCAPE_MAP = new Properties();

    private JavaScriptUtil() {
    }

    public static String escapeInStringLiterals(CharSequence text) {
        if (text == null) {
            return "";
        }
        StringBuilder buff = new StringBuilder(text.length() + 16);
        StringTokenizer st = new StringTokenizer(text.toString(), SPECIAL_CHARACTERS, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            buff.append(ESCAPE_MAP.getProperty(token, token));
        }
        return buff.toString();
    }

    public static List<String> escapeInStringLiterals(List<String> texts) {
        ArrayList<String> result = new ArrayList<String>();
        for (String text : texts) {
            result.add(JavaScriptUtil.escapeInStringLiterals(text));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obfuscateScript(CharSequence script) {
        block8: {
            if (script != null) break block8;
            String string = "";
            return string;
        }
        int stringFromCharCodeLimit = 100;
        int parametersPerLine = 10;
        float xorRate = 0.1f;
        StringBuilder buff = new StringBuilder(script.length() * 10 + 500);
        Formatter formatter = new Formatter(buff);
        String stringFromCharCode = JavaScriptUtil.stringFromCharCode(formatter);
        Map<String, Integer> xorFunctions = JavaScriptUtil.xorFunctions(formatter);
        String[] xorFuncNames = xorFunctions.keySet().toArray(new String[0]);
        formatter.format("/*%2$s*/\\u0065\\u0076\\u0061\\u006c/*%3$s*/(%1$s(32", JavaScriptUtil.formatArguments(3, stringFromCharCode));
        for (int i = 0; i < script.length(); ++i) {
            char code = script.charAt(i);
            if (i % 100 == 0) {
                formatter.format(")%n", new Object[0]);
                formatter.format("+/*%2$s*/%1$s(", JavaScriptUtil.formatArguments(2, stringFromCharCode));
            } else {
                buff.append(",");
                if (i % 10 == 0) {
                    formatter.format("%n", new Object[0]);
                }
            }
            if (RandomUtils.nextFloat() < 0.1f) {
                String xorFunc = xorFuncNames[i % xorFuncNames.length];
                int xor = xorFunctions.get(xorFunc);
                int xorCode = code ^ xor;
                formatter.format("%1$s(", xorFunc);
                formatter.format(JavaScriptUtil.numberFormat(i), xorCode);
                buff.append(")");
                continue;
            }
            formatter.format(JavaScriptUtil.numberFormat(i), code);
        }
        formatter.format("/*%1$s%2$s*/));/*%3$s*/%n", JavaScriptUtil.formatArguments(3, new Object[0]));
        String string = buff.toString();
        return string;
    }

    private static String stringFromCharCode(Formatter formatter) {
        String stringFromCharCode = "__" + JavaScriptUtil.randomAlphanumeric(3, 10);
        formatter.format("/*%2$s*/var/*%3$s*/%1$s/*%4$s*/=\\u0053\\u0074\\u0072\\u0069\\u006e\\u0067%n/*%5$s*/./*%6$s*/\\u0066r\\u006fm\\u0043ha\\u0072C\\u006fde/*%7$s*/;%n", JavaScriptUtil.formatArguments(7, stringFromCharCode));
        return stringFromCharCode;
    }

    private static Map<String, Integer> xorFunctions(Formatter formatter) {
        int[] xorArray = new int[5];
        for (int i = 0; i < xorArray.length; ++i) {
            xorArray[i] = RandomUtils.nextInt((int)4096);
        }
        String xorArrayName = "_x_" + JavaScriptUtil.randomAlphanumeric(3);
        formatter.format("var/*%2$s*/%1$s = [/*%3$s*/", JavaScriptUtil.formatArguments(3, xorArrayName));
        for (int i = 0; i < xorArray.length; ++i) {
            formatter.format("%d,", xorArray[i]);
        }
        formatter.format("/*%s*/];//%s%n", JavaScriptUtil.formatArguments(2, new Object[0]));
        HashMap<String, Integer> functions = new HashMap<String, Integer>();
        for (int i = 0; i < xorArray.length; ++i) {
            String func = "_$" + JavaScriptUtil.randomAlphanumeric(3, 5);
            formatter.format("var/*%2$s*/%1$s/*%3$s*/=/*%4$s*/function(/*%5$s*/){%n", JavaScriptUtil.formatArguments(5, func));
            formatter.format("/*%1$s*/return/*%2$s*/arguments[/*%3$s*/0]^/*%4$s*/%n", JavaScriptUtil.formatArguments(4, new Object[0]));
            formatter.format("/*%3$s*/%1$s[/*%4$s*/%2$d];/*%5$s*/}/*%6$s*/;%n", JavaScriptUtil.formatArguments(6, xorArrayName, i));
            functions.put(func, xorArray[i]);
        }
        return functions;
    }

    private static Object[] formatArguments(int count, Object ... firstFixedParameters) {
        if (count < firstFixedParameters.length) {
            throw new IllegalArgumentException("length < codes.length");
        }
        Object[] args = new Object[count];
        System.arraycopy(firstFixedParameters, 0, args, 0, firstFixedParameters.length);
        for (int i = firstFixedParameters.length; i < args.length; ++i) {
            args[i] = JavaScriptUtil.randomAlphanumeric(5, 20);
        }
        return args;
    }

    private static String randomAlphanumeric(int length) {
        return JavaScriptUtil.randomAlphanumeric(length, length);
    }

    private static String randomAlphanumeric(int minLength, int maxLength) {
        if (minLength <= 0) {
            throw new IllegalArgumentException("minLength <= 0");
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength <= 0");
        }
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength > maxLength");
        }
        if (minLength == maxLength) {
            return RandomStringUtils.randomAlphanumeric((int)minLength);
        }
        int length = minLength + RandomUtils.nextInt((int)(maxLength - minLength));
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    private static String numberFormat(int seed) {
        int rnd = RandomUtils.nextInt((int)(Math.abs(seed) + 100));
        switch (rnd % 17) {
            case 0: {
                return "0x%x";
            }
            case 1: {
                return String.format("-1-~/*%s*/(0x%%x^0)", JavaScriptUtil.randomAlphanumeric(2, 5));
            }
            case 2: {
                return String.format("%%d%d/0xA", RandomUtils.nextInt((int)10));
            }
            case 3: {
                return "Math.abs(%d)&-1";
            }
            case 4: {
                return "0%o";
            }
            case 5: {
                return "%d&(-1^0x00)";
            }
            case 6: {
                return "0x0|0x%x";
            }
            case 7: {
                return String.format("~/*%s*/~/*%s*/%%d", JavaScriptUtil.formatArguments(2, new Object[0]));
            }
            case 8: {
                return String.format("~(0x%%x^/*%s*/-1)", JavaScriptUtil.randomAlphanumeric(2, 5));
            }
            case 9: {
                return String.format("0x%%x%d%d/0400", RandomUtils.nextInt((int)10), RandomUtils.nextInt((int)10));
            }
            case 10: {
                return String.format("0x%%x%d%d>>/*%s*/4>>4", JavaScriptUtil.formatArguments(3, RandomUtils.nextInt((int)10), RandomUtils.nextInt((int)10)));
            }
            case 11: {
                return String.format("%%d/*%s*/", JavaScriptUtil.randomAlphanumeric(2));
            }
        }
        return "%d";
    }

    static {
        ESCAPE_MAP.put("\n", "\\n");
        ESCAPE_MAP.put("\r", "\\r");
        ESCAPE_MAP.put("\f", "\\f");
        ESCAPE_MAP.put("'", "\\'");
        ESCAPE_MAP.put("\"", "\\\"");
        ESCAPE_MAP.put("\\", "\\\\");
    }
}

