package cn.com.duiba.wolf.dubbo.dispatcher;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 注释在dubbo的RemoteService接口上,表示该RemoteService需要在哪个线程池中运行,默认在dubbo线程池中运行。
 * 在需要隔离不同服务防止互相影响时有用。
 * <br/><br/>
 * 一种互相影响的场景是:某个数据库访问有瓶颈,导致大量线程超时,从而耗尽线程池,可以把不同数据库的remoteService放在不同的线程池中运行,从而避免影响到其他数据库的remoteService。
 * Created by wenqi.huang on 16/7/28.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface RunInExecutor {
    /**
     * 决定当前的RemoteService在哪个线程池中运行。默认default,在dubbo默认线程池中运行,指定的其他名字必须能在springContext中找到该名字的线程池
     * @return
     */
    String value() default "default";
}
