package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;

/**
 * Created by xuezhaoming on 16/6/1.<br/>
 * dubbo服务的接口服务
 */
@Activate(group = { Constants.PROVIDER }, order = -9001)//CatTransaction的order为9000，让MonitorFilter在cat之前
public class MonitorFilter implements Filter {

    static {
        InitOperation.init();
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        RpcContext context = RpcContext.getContext();
        boolean providerSide = context.isProviderSide();
        if (providerSide) {
            DBTimeProfile.start();
        }

        String methodName = invocation.getInvoker().getInterface().getSimpleName() + "." + invocation.getMethodName();
        try {
            return invoker.invoke(invocation);
        } finally {

            if (providerSide) {
                DBTimeProfile.end(methodName);
            }
        }

    }
}
