/*
 * Copyright 1999-2011 Alibaba Group.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.wolf.dubbo.dispatcher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.ExecutionException;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.transport.dispatcher.ChannelEventRunnable;
import com.alibaba.dubbo.remoting.transport.dispatcher.ChannelEventRunnable.ChannelState;
import com.alibaba.dubbo.remoting.transport.dispatcher.WrappedChannelHandler;
import com.alibaba.dubbo.rpc.Invocation;

import java.util.Map;
import java.util.concurrent.ExecutorService;

@Deprecated
public class RoutingChannelHandler extends WrappedChannelHandler {

    protected static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(RoutingChannelHandler.class);

    private Map<String, ExecutorService> executorMap;

    public RoutingChannelHandler(ChannelHandler handler, URL url, Map<String, ExecutorService> executorMap) {
        super(handler, url);
        this.executorMap = executorMap;
    }

    public void connected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, handler, ChannelState.CONNECTED));
        } catch (Throwable t) {
            throw new ExecutionException("connect event", channel, getClass() + " error when process connected event .", t);
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        ExecutorService cexecutor = getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, handler, ChannelState.DISCONNECTED));
        } catch (Throwable t) {
            throw new ExecutionException("disconnect event", channel, getClass() + " error when process disconnected event .", t);
        }
    }

    public void received(Channel channel, Object message) throws RemotingException {
        ExecutorService cexecutor = getExecutorService(message);
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, handler, ChannelState.RECEIVED, message));
        } catch (Throwable t) {
            throw new ExecutionException(message, channel, getClass() + " error when process received event .", t);
        }
    }

    public void caught(Channel channel, Throwable exception) throws RemotingException {
        ExecutorService cexecutor = getExecutorService();
        try {
            cexecutor.execute(new ChannelEventRunnable(channel, handler, ChannelState.CAUGHT, exception));
        } catch (Throwable t) {
            throw new ExecutionException("caught event", channel, getClass() + " error when process caught event .", t);
        }
    }

    private ExecutorService getExecutorService() {
        ExecutorService cexecutor = executor;
        if (cexecutor == null || cexecutor.isShutdown()) {
            cexecutor = SHARED_EXECUTOR;
        }
        return cexecutor;
    }

    private ExecutorService getExecutorService(Object message) {
        try {
            Object inv = message;
            if (message instanceof Request) {
                inv = ((Request) message).getData();
            }
            if (!(inv instanceof Invocation)) {
                return getExecutorService();
            }
            Invocation invocation = (Invocation) inv;
            String interfaceName = invocation.getAttachment("interface");
            Class<?> clazz = Class.forName(interfaceName);
            if (!clazz.isAnnotationPresent(RunInExecutor.class)) {
                return getExecutorService();
            }

            RunInExecutor annotation = clazz.getAnnotation(RunInExecutor.class);
            String executorKey = annotation.value();
            if ("default".equals(executorKey)) {
                return getExecutorService();
            } else {
                ExecutorService executor = executorMap.get(executorKey);
                if (executor != null) {
                    if(log.isDebugEnabled()) {
                        log.debug(interfaceName + "." + invocation.getMethodName() + " run in executor:" + executorKey);
                    }
                    return executor;
                } else {
                    log.error("warn: threadPool of key:[" + executorKey + "] not exists in springContext, will use default");
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return getExecutorService();
    }
}
