/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.io.UnsafeStringWriter;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericService;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;

@Activate(group={"provider"}, order=-8999)
public class RuntimeExceptionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);
    private static String SYSTEM_NAME = "--";
    private static final Set<Class<? extends RuntimeException>> serviceInternalRuntimeExceptions = new HashSet<Class<? extends RuntimeException>>();

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            DBTimeProfile.enter("RuntimeExceptionFilter start");
            Result result = invoker.invoke(invocation);
            if (result.hasException() && GenericService.class != invoker.getInterface()) {
                Class<?>[] exceptionClassses;
                Throwable exception;
                block25: {
                    try {
                        exception = result.getException();
                        if (exception instanceof RuntimeException || !(exception instanceof Exception)) break block25;
                        Result result2 = result;
                        return result2;
                    }
                    catch (Throwable e) {
                        Result result3 = result;
                        return result3;
                    }
                }
                if (exception instanceof RpcException) {
                    Result result4 = result;
                    return result4;
                }
                Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                    if (!exception.getClass().equals(exceptionClass)) continue;
                    Result result5 = result;
                    return result5;
                }
                Class<?> clazz = method.getReturnType();
                if (clazz.equals(Void.TYPE)) {
                    Result len$ = result;
                    return len$;
                }
                if (clazz.equals(DubboResult.class)) {
                    this.logException(invocation.getArguments(), exception);
                    String exceptionMsg = exception.getMessage();
                    if (exception.getCause() == null && exception.getClass().equals(RuntimeException.class) && !StringUtils.isEmpty((String)exceptionMsg)) {
                        RpcResult i$ = new RpcResult((Object)DubboResult.failResult((String)exception.getMessage()));
                        return i$;
                    }
                    if (serviceInternalRuntimeExceptions.contains(exception.getClass())) {
                        DubboResult dubboResult = DubboResult.failResult((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                        dubboResult.setReturnCode(SYSTEM_NAME + "0102");
                        RpcResult rpcResult = new RpcResult((Object)dubboResult);
                        return rpcResult;
                    }
                    RpcResult rpcResult = new RpcResult((Object)DubboResult.failResult((String)exception.getMessage()));
                    return rpcResult;
                }
                Result result6 = result;
                return result6;
            }
            Result result7 = result;
            return result7;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void logException(Object[] arguments, Throwable exception) {
        StringBuilder message = new StringBuilder(exception.getMessage());
        message.append(" params : ");
        String argumentsStr = arguments.toString();
        int maxArgumentsStrLen = 300;
        if (argumentsStr != null && argumentsStr.length() > maxArgumentsStrLen) {
            argumentsStr = argumentsStr.substring(0, maxArgumentsStrLen);
            message.append(argumentsStr).append(" ... (").append(argumentsStr.length() - maxArgumentsStrLen).append(" more characters).");
        } else {
            message.append(argumentsStr);
        }
        log.error(message.toString(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toShortString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        try (PrintWriter p = new PrintWriter((Writer)w);){
            this.printStackTrace(e, p, true);
            String string = w.toString();
            return string;
        }
    }

    private void printStackTrace(Throwable e, PrintWriter p, boolean isTop) {
        if (e != null) {
            if (isTop) {
                p.println(e);
            } else {
                p.println("Caused by: " + e);
            }
            StackTraceElement[] trace = e.getStackTrace();
            int i = 0;
            int lastPrintedLineNumber = 0;
            for (StackTraceElement traceElement : trace) {
                if (i < 2 || traceElement.getClassName().startsWith("cn.com.duiba")) {
                    if (lastPrintedLineNumber < i - 1) {
                        p.println("\t...");
                    }
                    p.println("\tat " + traceElement);
                    lastPrintedLineNumber = i;
                }
                ++i;
            }
            this.printStackTrace(e.getCause(), p, false);
        }
    }

    protected static void registerSystemName(String systemName) {
        if (StringUtils.isEmpty((String)systemName)) {
            throw new IllegalArgumentException("systemName must not be null");
        }
        if (systemName.length() != 2) {
            throw new IllegalArgumentException("systemName's length must be 2");
        }
        SYSTEM_NAME = systemName;
    }

    public static void main(String[] args) {
        RuntimeException r = new RuntimeException();
        System.out.println(r.getClass().equals(RuntimeException.class));
        r = new NullPointerException();
        System.out.println(r.getClass().equals(RuntimeException.class));
    }

    static {
        serviceInternalRuntimeExceptions.add(NestedRuntimeException.class);
    }
}

