/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.redis;

import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duiba.wolf.log.DegradeLogger;
import com.dianping.cat.Cat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisAtomicClient {
    private static final Logger logger = DegradeLogger.wrap(LoggerFactory.getLogger(RedisAtomicClient.class));
    private final RedisTemplate redisTemplate;
    private RedisSerializer<String> keyRedisSerializer = new StringRedisSerializer();
    private RedisSerializer<String> stringRedisSerializer = new StringRedisSerializer();
    private StringScriptExecutor stringScriptExecutor;
    private static final String INCR_BY_WITH_TIMEOUT = "local v; v = redis.call('incrBy',KEYS[1],ARGV[1]);if tonumber(v) == 1 then\n    redis.call('expire',KEYS[1],ARGV[2])\nend\nreturn v";

    public RedisAtomicClient(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        if (this.stringScriptExecutor == null) {
            this.stringScriptExecutor = new StringScriptExecutor(redisTemplate);
        }
    }

    public Long getLong(String key) {
        final byte[] rawKey = this.rawKey(key);
        try {
            String val = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

                public String doInRedis(RedisConnection connection) throws DataAccessException {
                    byte[] valueBytes = connection.get(rawKey);
                    return (String)RedisAtomicClient.this.stringRedisSerializer.deserialize(valueBytes);
                }
            }, true);
            if (val == null) {
                return null;
            }
            return Long.valueOf(val);
        }
        catch (Exception e) {
            logger.error("get key error:" + key, (Throwable)e);
            if (CatInstance.isEnable()) {
                Cat.logError((Throwable)e);
            }
            return null;
        }
    }

    public Long incrBy(String key, long delta, long timeout, TimeUnit timeUnit) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        long timeoutSeconds = TimeUnit.SECONDS.convert(timeout, timeUnit);
        Object[] args = new String[]{String.valueOf(delta), String.valueOf(timeoutSeconds)};
        Object currentVal = this.stringScriptExecutor.execute((RedisScript)new DefaultRedisScript(INCR_BY_WITH_TIMEOUT, String.class), this.keyRedisSerializer, this.stringRedisSerializer, keys, args);
        if (currentVal instanceof Long) {
            return (Long)currentVal;
        }
        return Long.valueOf((String)currentVal);
    }

    private byte[] rawKey(String key) {
        return this.keyRedisSerializer.serialize((Object)key);
    }

    private class StringScriptExecutor
    extends DefaultScriptExecutor<String> {
        public StringScriptExecutor(RedisTemplate<String, ?> template) {
            super(template);
        }

        protected byte[][] keysAndArgs(RedisSerializer argsSerializer, List<String> keys, Object[] args) {
            int keySize = keys != null ? keys.size() : 0;
            byte[][] keysAndArgs = new byte[args.length + keySize][];
            int i = 0;
            if (keys != null) {
                for (String key : keys) {
                    keysAndArgs[i++] = RedisAtomicClient.this.keyRedisSerializer.serialize((Object)key);
                }
            }
            for (Object arg : args) {
                keysAndArgs[i++] = argsSerializer == null && arg instanceof byte[] ? (byte[])arg : argsSerializer.serialize(arg);
            }
            return keysAndArgs;
        }
    }
}

