/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.threadpool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCallable
implements Callable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorCallable.class);
    private Callable callable;
    private BlockingQueue<Runnable> queue;
    private final long submitTimeMillis;

    public MonitorCallable(Callable callable) {
        this.callable = callable;
        this.submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorCallable(Callable callable, BlockingQueue<Runnable> queue) {
        this(callable);
        this.queue = queue;
    }

    public Object call() throws Exception {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= 1000L) {
            if (this.queue == null) {
                logger.error("ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.error("ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        return this.callable.call();
    }
}

