/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.threadpool;

import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRunnable.class);
    static final int MAX_WAIT_TIME_MILLIS = 1000;
    private Runnable runnable;
    private BlockingQueue<Runnable> queue;
    private final long submitTimeMillis;

    public MonitorRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue) {
        this(runnable);
        this.queue = queue;
    }

    @Override
    public void run() {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= 1000L) {
            if (this.queue == null) {
                logger.error("ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.error("ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
}

