/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class HtmlUtils {
    private static PolicyFactory policyBuilder = new HtmlPolicyBuilder().allowAttributes(new String[]{"src", "title"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"class", "id", "style"}).onElements(new String[]{"span"}).allowStandardUrlProtocols().allowElements(new String[]{"a", "label", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "font", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "col", "fieldset", "legend", "samp", "cite", "pre", "code", "big", "small"}).toFactory();

    public static String cleanXss(String htmlString) {
        if (com.alibaba.dubbo.common.utils.StringUtils.isBlank((String)htmlString)) {
            return htmlString;
        }
        htmlString = HtmlUtils.preprocess(htmlString);
        return policyBuilder.sanitize(htmlString);
    }

    @Deprecated
    private static String preprocess(String htmlString) {
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff1f", (String)"?");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff01", (String)"!");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff0c", (String)",");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff1b", (String)";");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff08", (String)"(");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff09", (String)")");
        htmlString = StringUtils.replace((String)htmlString, (String)"\uff1a", (String)":");
        return htmlString;
    }

    public static String cleanXssOfJsonString(String jsonString) {
        if (com.alibaba.dubbo.common.utils.StringUtils.isBlank((String)jsonString)) {
            return jsonString;
        }
        if ((jsonString = HtmlUtils.preprocess(jsonString)).startsWith("[")) {
            JSONArray jsonArray = HtmlUtils.cleanXssOfJsonArray(JSONArray.fromObject((Object)jsonString));
            return jsonArray.toString();
        }
        if (jsonString.startsWith("{")) {
            JSONObject jsonObject = HtmlUtils.cleanXssOfJsonObject(JSONObject.fromObject((Object)jsonString));
            return jsonObject.toString();
        }
        return jsonString;
    }

    private static JSONArray cleanXssOfJsonArray(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return jsonArray;
        }
        JSONArray retJsonArray = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object object = jsonArray.get(i);
            if (object instanceof JSONArray) {
                retJsonArray.add((Object)HtmlUtils.cleanXssOfJsonArray((JSONArray)object));
                continue;
            }
            if (object instanceof JSONObject) {
                retJsonArray.add((Object)HtmlUtils.cleanXssOfJsonObject((JSONObject)object));
                continue;
            }
            if (object instanceof String) {
                retJsonArray.add((Object)HtmlUtils.cleanXss((String)object));
                continue;
            }
            retJsonArray.add(object);
        }
        return retJsonArray;
    }

    private static JSONObject cleanXssOfJsonObject(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return jsonObject;
        }
        JSONObject retJsonObject = new JSONObject();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof JSONArray) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXssOfJsonArray((JSONArray)object));
                continue;
            }
            if (object instanceof JSONObject) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXssOfJsonObject((JSONObject)object));
                continue;
            }
            if (object instanceof String) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXss((String)object));
                continue;
            }
            retJsonObject.put((Object)key, object);
        }
        return retJsonObject;
    }

    public static void main(String[] args) {
        String html = "<img class='a' src='b.jpg'></img><script>alert('\uff1f\uff1f');</script><a class='a'  href='https://www.baidu.com/search/error.html?a=1'>\uff1f\uff1f\uff1fhttp://www.baidu.com\uff1f</a><div></div><h1 class='aa'>hello world\u53d1\u8fbe</h1><h2 style='display:none;'></h2>";
        String cleanedHtml = HtmlUtils.cleanXss(html);
        System.out.println(cleanedHtml);
        html = "hello world<img></img><hello></hello>";
        cleanedHtml = HtmlUtils.cleanXss(html);
        System.out.println(cleanedHtml);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put((Object)"name", (Object)"jack");
        jsonObject1.put((Object)"address", (Object)html);
        JSONArray nameArr = new JSONArray();
        nameArr.add((Object)"hello");
        nameArr.add((Object)"hello2");
        nameArr.add((Object)jsonObject1);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)"");
        jsonObject.put((Object)"address", (Object)html);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        jsonArray.add((Object)jsonObject);
        jsonArray.add((Object)jsonObject);
        String cleanedJsonString = HtmlUtils.cleanXssOfJsonString(jsonArray.toString());
        System.out.println(cleanedJsonString);
        cleanedJsonString = HtmlUtils.cleanXssOfJsonString(jsonObject.toString());
        System.out.println();
        System.out.println(cleanedJsonString);
        String code = "{\"code\":\"http://m.duzhoumo.com/zhuanti/2016scyhq?channelid=24\",\"remaind\":\"3\"}";
        code = StringEscapeUtils.unescapeHtml((String)code);
        System.out.println(code);
        code = HtmlUtils.cleanXssOfJsonString(code);
        System.out.println(code);
    }
}

