package cn.com.duiba.wolf.threadpool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

/**
 * Callable的包装类，可以监控Callable从提交到线程池到开始执行花了多久，如果过久则打印warn日志
 * Created by wenqi.huang on 2017/2/5.
 */
public class MonitorCallable implements Callable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorCallable.class);

    private Callable callable;

    /**
     * 线程池中的queue，当超时的时候可以打印出大小
     */
    private BlockingQueue<Runnable> queue;

    //这个时间用于记录什么时候提交到线程池
    private final long submitTimeMillis;

    public MonitorCallable(Callable callable){
        this.callable = callable;
        submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorCallable(Callable callable, BlockingQueue<Runnable> queue){
        this(callable);
        this.queue = queue;
    }

    public long getSubmitTimeMillis() {
        return submitTimeMillis;
    }

    public Callable getCallable() {
        return callable;
    }

    @Override
    public Object call() throws Exception {
        long waitTimeMillis = System.currentTimeMillis() - submitTimeMillis;
        if(waitTimeMillis >= MonitorRunnable.MAX_WAIT_TIME_MILLIS){
            if(queue == null) {
                logger.error("ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis});
            }else{
                logger.error("ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis, queue.size()});
            }
        }

        return callable.call();
    }
}
