package cn.com.duiba.wolf.utils;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by wenqi.huang on 2017/6/19.
 */
public class CatUtils {
    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);
    //cat的jar包是否引入了
    private static final boolean isCatImportted;
    static{
        boolean catImportted = false;
        try {
            Class.forName("cn.com.duiba.catmonitor.CatInstance");
            catImportted = true;
        } catch (ClassNotFoundException e) {
            //Ignore
        }
        isCatImportted = catImportted;
    }

    private CatUtils(){}

    public static void logError(Exception e){
        if(isCatImportted) {
            if (CatInstance.isEnable()) {
                Cat.logError(e);
            }
        }else{
            logger.warn("Cat is not importted, will not logError");
        }
    }
}
