package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.ManageUser;
import cn.com.duiba.youqian.center.api.request.manage.SearchManageUserRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description Manage
 */
@AdvancedFeignClient
public interface RemoteManageService {

    /**
     * 后台登陆
     *
     * @param account  account
     * @param password password
     * @return ManageUser
     * @throws BizException 账号或密码错误
     */
    ManageUser login(String account, String password) throws BizException;

    /**
     * 查询ManagerUser
     *
     * @param managerUserId managerUserId
     * @return ManageUser
     * @throws BizException 用户已存在
     */
    ManageUser getManageUser(Long managerUserId) throws BizException;

    /**
     * 搜索后台用户
     *
     * @param request request
     * @return PageResult<ManageUser>
     */
    PageResult<ManageUser> pageList(SearchManageUserRequest request) throws BizException;

    /**
     * 新增
     *
     * @param manageUser manageUser
     * @return userId
     * @throws BizException 账号已存在
     */
    Long add(ManageUser manageUser) throws BizException;

    /**
     * 更新
     *
     * @param manageUser manageUser
     * @throws BizException 账号不存在
     */
    void update(ManageUser manageUser) throws BizException;

}
