package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.GoodsSpec;
import cn.com.duiba.youqian.center.api.entity.Merchant;
import cn.com.duiba.youqian.center.api.entity.Organization;
import cn.com.duiba.youqian.center.api.entity.Role;
import cn.com.duiba.youqian.center.api.request.merchant.*;
import cn.com.duiba.youqian.center.api.result.PageResult;
import cn.com.duiba.youqian.center.api.result.merchant.CustomerVO;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 新增商户
     *
     * @param merchant merchant
     * @return merchantId
     * @throws BizException 商户已经存在
     */
    Long add(Merchant merchant) throws BizException;

    /**
     * 更新商户
     *
     * @param merchant merchant
     * @throws BizException 商户不存在
     */
    void update(Merchant merchant) throws BizException;

    /**
     * 获取商户
     *
     * @param merchantId merchantId
     * @return Merchant
     * @throws BizException 商户不存在
     */
    Merchant get(Long merchantId) throws BizException;

    /**
     * 分页搜索商户
     *
     * @param request request
     * @return PageResult<Merchant>
     */
    PageResult<Merchant> pageList(SearchMerchantRequest request) throws BizException;

    /**
     * 商户列表
     *
     * @param request request
     * @return List<Merchant>
     */
    List<Merchant> list(ListMerchantRequest request) throws BizException;

    /**
     * 角色列表
     *
     * @param merchantId merchantId
     * @return Role
     */
    List<Role> getRoleList(Long merchantId) throws BizException;

    /**
     * 获取商户部门列表
     *
     * @param request request
     * @return Organization
     */
    PageResult<Organization> orgPageList(SearchOrgRequest request) throws BizException;

    /**
     * 获取所有组织
     *
     * @param merchantId merchantId
     * @return List<Organization>
     */
    List<Organization> orgList(Long merchantId) throws BizException;

    /**
     * 添加部门
     *
     * @param organization organization
     * @return orgId
     * @throws BizException 组织已存在
     */
    Long addOrg(Organization organization) throws BizException;

    /**
     * 客户列表
     */
    PageResult<CustomerVO> customerPageList(SearchCustomerRequest request) throws BizException;

    /**
     * 商品列表
     */
    PageResult<GoodsSpec> goodsList(SearchGoodsRequest request) throws BizException;
}
