package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.SignEntity;
import cn.com.duiba.youqian.center.api.request.merchant.SearchSignEntityRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/7
 * @description
 */
@AdvancedFeignClient
public interface RemoteSignEntityService {

    /**
     * 添加签约主体
     *
     * @param signEntity signEntity
     * @return signEntityId
     * @throws BizException 签约主体已存在
     */
    Long add(SignEntity signEntity) throws BizException;

    /**
     * 更新签约主体
     *
     * @param signEntity signEntity
     * @throws BizException 签约主体不存在
     */
    void update(SignEntity signEntity) throws BizException;

    /**
     * 获取签约主体
     *
     * @param signEntityId signEntityId
     * @return SignEntity
     * @throws BizException 签约主体不存在
     */
    SignEntity get(Long signEntityId) throws BizException;

    /**
     * 根据商户ID获取所有签约主体
     *
     * @param merchantId merchantId
     * @return List<SignEntity>
     */
    List<SignEntity> getByMerchantId(Long merchantId) throws BizException;

    /**
     * 分页搜索签约主体
     *
     * @param request request
     * @return PageResult<SignEntity>
     */
    PageResult<SignEntity> pageList(SearchSignEntityRequest request) throws BizException;

}
