package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.PlatformUser;
import cn.com.duiba.youqian.center.api.request.user.SearchUserRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 登陆校验
     *
     * @param account  account
     * @param password password
     * @return PlatformUser
     * @throws BizException 账号或密码不正确
     */
    PlatformUser login(String account, String password) throws BizException;

    /**
     * 根据Account查询User
     *
     * @param account account
     * @return PlatformUser
     */
    PlatformUser getByAccount(String account) throws BizException;

    /**
     * 根据UserId获取用户信息
     *
     * @param userId userId
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUser get(Long userId) throws BizException;

    /**
     * 注册用户
     *
     * @param platformUser platformUser
     * @return userId
     * @throws BizException 用户已存在
     */
    Long register(PlatformUser platformUser) throws BizException;

    /**
     * 更新用户信息
     *
     * @param platformUser platformUser
     * @throws BizException 用户不存在
     */
    void update(PlatformUser platformUser) throws BizException;

    /**
     * 搜索用户
     *
     * @param request request
     * @return PageResult<PlatformUser>
     */
    PageResult<PlatformUser> pageList(SearchUserRequest request) throws BizException;


}
