/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.util;

import cn.com.duiba.youqian.center.api.util.AsianFontProvider;
import com.itextpdf.text.Document;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtil {
    private static final Logger log = LoggerFactory.getLogger(PDFUtil.class);

    public static byte[] replacePdf(String title, String content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Document document = new Document(PageSize.LETTER);
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            document.open();
            document.addCreationDate();
            document.addTitle(title);
            XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
            worker.parseXHtml(pdfWriter, document, (InputStream)new ByteArrayInputStream(content.getBytes()), null, (FontProvider)new AsianFontProvider());
            document.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int getPages(byte[] pdfByte) {
        PDDocument pdDocument = null;
        try {
            pdDocument = PDDocument.load((byte[])pdfByte);
        }
        catch (IOException e) {
            log.error("IO exception:[{}]", (Throwable)e);
        }
        return pdDocument.getNumberOfPages();
    }

    public static int[] getLastPage(byte[] pdfData) {
        int[] obj = new int[2];
        try {
            PDDocument pdDocument = PDDocument.load((byte[])pdfData);
            int pages = pdDocument.getNumberOfPages();
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setSortByPosition(true);
            stripper.setStartPage(pages);
            stripper.setEndPage(pages);
            String content = stripper.getText(pdDocument);
            pdDocument.close();
            obj[0] = pages;
            obj[1] = PDFUtil.getPDFLine(content);
        }
        catch (IOException e) {
            log.error("IO exception:[{}]", (Throwable)e);
        }
        return obj;
    }

    public static int getPDFLine(String content) {
        int line = 0;
        char[] chars = content.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    public static void replaceHtml(String writePath, String content) {
        try {
            if (StringUtils.contains((CharSequence)writePath, (CharSequence)".pdf")) {
                writePath = StringUtils.substringBefore((String)writePath, (String)".pdf") + ".html";
            }
            Files.write(Paths.get(writePath, new String[0]), content.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void downloadLocalPDF(byte[] response_str, String fileName) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        IOUtils.write((byte[])response_str, (OutputStream)fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byte2File(byte[] buf, String fileName) {
        String filePath = "C:\\Users\\Duiba\\Desktop\\";
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath + File.separator + fileName;
    }
}

