package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.youqian.center.api.entity.RoleMenu;
import cn.com.duiba.youqian.center.api.entity.RolePermission;
import cn.com.duiba.youqian.center.api.result.merchant.RoleVO;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author tengtuox
 * @date 2019/12/30
 * @description 默认角色（用于初始化）
 */
@Getter
public enum EnumRole {

    ADMIN("管理员", EnumMenu.merchantMenuList(),
            Collections.singletonList(EnumPermission.SEE_MERCHANT_CONTRACT)),

    SALESMAN("员工", Arrays.asList(EnumMenu.SALE,
            EnumMenu.ORDER_CONTRACT,
            EnumMenu.GOODS,
            EnumMenu.CUSTOMER),
            Collections.emptyList()),

    ORG_ADMIN("部门经理", Arrays.asList(EnumMenu.SALE,
            EnumMenu.ORDER_CONTRACT,
            EnumMenu.GOODS,
            EnumMenu.CUSTOMER),
            Collections.singletonList(EnumPermission.SEE_ORGANIZATION_CONTRACT)),
    ;

    private String roleName;

    private List<EnumMenu> defaultMenus;

    private List<EnumPermission> defaultPermissions;

    EnumRole(String roleName, List<EnumMenu> defaultMenus, List<EnumPermission> defaultPermissions) {
        this.roleName = roleName;
        this.defaultMenus = defaultMenus;
        this.defaultPermissions = defaultPermissions;
    }

    public static List<RoleVO> getInitRole(Long merchantId) {
        List<RoleVO> roleList = new ArrayList<>(EnumRole.values().length);

        for (EnumRole e : EnumRole.values()) {
            RoleVO role = new RoleVO();
            role.setRoleName(e.getRoleName());
            role.setMerchantId(merchantId);

            // 角色菜单
            List<RoleMenu> roleMenus = new ArrayList<>(e.defaultMenus.size());
            for (EnumMenu menu : e.defaultMenus) {
                RoleMenu roleMenu = menu.getRoleMenu(merchantId);
                roleMenus.add(roleMenu);
            }
            role.setMenuList(roleMenus);

            // 角色权限
            if (CollectionUtils.isNotEmpty(e.defaultPermissions)) {
                List<RolePermission> rolePermissions = new ArrayList<>(e.defaultPermissions.size());

                for (EnumPermission permission : e.defaultPermissions) {
                    RolePermission rolePermission = permission.getRolePermission(merchantId);
                    rolePermissions.add(rolePermission);
                }

                role.setPermissionList(rolePermissions);
            }
            roleList.add(role);
        }

        return roleList;
    }

}
