package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.MerchantTemplate;
import cn.com.duiba.youqian.center.api.entity.Template;
import cn.com.duiba.youqian.center.api.request.contract.PageTemplateRequest;
import cn.com.duiba.youqian.center.api.request.merchant.PageMerchantTemplateRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

/**
 * @author tengtuox
 * @date 2020/1/11
 * @description
 */
@AdvancedFeignClient
public interface RemoteTemplateService {

    /**
     * 模板分页
     */
    PageResult<Template> templatePageList(PageTemplateRequest request) throws BizException;

    /**
     * 模板详情
     *
     * @param templateId 模板ID
     * @throws BizException 模板不存在
     */
    Template get(Long templateId) throws BizException;

    /**
     * 更新模板
     *
     * @param template 非空更新
     * @throws BizException 模板不存在
     */
    void update(Template template) throws BizException;

    /**
     * 新增模板
     *
     * @param template 非空新增
     * @return 模板ID
     * @throws BizException 模板已存在
     */
    Long add(Template template) throws BizException;

    /**
     * 模板列表
     *
     * @param request request
     */
    PageResult<MerchantTemplate> mTemplatePage(PageMerchantTemplateRequest request) throws BizException;

    /**
     * 新增模板
     *
     * @param merchantTemplate merchantTemplate
     * @return 主键ID
     * @throws BizException 模板已经添加
     */
    Long addMerchantTemplate(MerchantTemplate merchantTemplate) throws BizException;

    /**
     * 更新模板
     *
     * @param merchantTemplate merchantTemplate
     * @throws BizException 模板不存在
     */
    void updateMerchantTemplate(MerchantTemplate merchantTemplate) throws BizException;
}
