package cn.com.duiba.youqian.center.api.request.merchant;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/1/8
 * @description
 */
@Data
public class SearchEmpRequest implements Serializable {

    private static final long serialVersionUID = 2036920089930311639L;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "商户ID", required = true)
    private Long merchantId;

    @ApiModelProperty("名称或手机号")
    private String keyword;

    @ApiModelProperty("超级管理员，0-不是/1-是")
    private Byte superAdmin;

}
