package cn.com.duiba.youqian.center.api.request.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@Data
public class OrderInfoRequest {

    @NotBlank(message = "买家名字不能为空")
    @ApiModelProperty(value = "买家名字", required = true)
    private String name;

    @NotBlank(message = "卖家ID不能为空")
    @ApiModelProperty(value = "卖家id", required = true)
    private Long shellUserId;

    @ApiModelProperty(value = "签约主体id", required = true)
    private Long signEntityId;

    @NotBlank(message = "买家手机号不能为空")
    @ApiModelProperty(value = "买家手机号", required = true)
    private String phone;

    @ApiModelProperty(value = "订单原价", required = true)
    private String originPrice;

    @ApiModelProperty(value = "订单种类数目", required = true)
    private String itemCount;

    @ApiModelProperty(value = "货物数量", required = true)
    private String goodsCount;

    @ApiModelProperty(value = "实际价格", required = true)
    private String price;

    @ApiModelProperty(value = "定金", required = true)
    private String earnestMoney;

    @ApiModelProperty(value = "发货时间", required = true)
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date transDate;

    @ApiModelProperty(value = "运输方式", required = true)
    private int transMethod;

    @ApiModelProperty(value = "其他约定事项", required = true)
    private int otherDesc;

    @ApiModelProperty(value = "商品列表", required = true)
    private List<GoodsReq> list;
}
