package cn.com.duiba.youqian.center.api.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * @类描述 实现java html 转pdf
 */
@Slf4j
public class PDFUtil {



	public static byte[] replacePdf(String title,String content) {
		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		try {
			Document document = new Document(PageSize.LETTER);
			PdfWriter pdfWriter = PdfWriter.getInstance(document,
					byteArrayOutputStream);
			document.open();
			document.addCreationDate();
			document.addTitle(title);
			XMLWorkerHelper worker = XMLWorkerHelper.getInstance();
			worker.parseXHtml(pdfWriter, document, new ByteArrayInputStream(content.getBytes()), null, new AsianFontProvider());
			document.close();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return byteArrayOutputStream.toByteArray();
	}

	/**
	 * 获取PDF 总页数
	 */
	public static int getPages(byte[] pdfByte){
		//2 加载PDF
		PDDocument pdDocument = null;
		try {
			pdDocument = PDDocument.load(pdfByte);
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}
		// 3 获取页码
		return pdDocument.getNumberOfPages();
	}

	/**
	 * 返回PDF 最后一页的信息
	 * @param pdfData PDF byte值
	 * @return obj[0] 页数,obj[1] 最后一页的行数
	 */
	public static int[] getLastPage(byte[] pdfData){
		//2 加载PDF
		int[] obj = new int[2];
		PDDocument pdDocument;
		int pages;
		String content;
		try {
			pdDocument = PDDocument.load(pdfData);
			// 3 获取页码
			pages = pdDocument.getNumberOfPages();
			// 4 读文本内容
			PDFTextStripper stripper=new PDFTextStripper();
			// 5 设置按顺序输出,返回最后一页的内容
			stripper.setSortByPosition(true);
			stripper.setStartPage(pages);
			stripper.setEndPage(pages);
			content = stripper.getText(pdDocument);
			pdDocument.close();
			obj[0] = pages;
			obj[1] = getPDFLine(content);
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}
		return obj;
	}

	/**
	 * PDF 内容获取行数
	 */
	public static int getPDFLine(String content){
		int line = 0;
		char[] chars = content.toCharArray();
		for(int i=0;i<chars.length;i++){
			if(chars[i] == '\n'){
				line ++;
			}
		}
		return line;
	}

    /**
     * 根据pdf转为html文件
	 * @param writePath
     * @param content
	 */
	public static void replaceHtml(String  writePath,String content) {
		try {
			if (StringUtils.contains(writePath, ".pdf")) {
				writePath = StringUtils.substringBefore(writePath, ".pdf") + ".html";
			}
			Files.write(Paths.get(writePath), content.getBytes("UTF-8"));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 *
	 */
	public void downloadLocalPDF(byte[] response_str,String fileName) throws IOException {
		FileOutputStream fileOutputStream = new FileOutputStream(fileName);//存储路径，例：F://test//1.pdf
		IOUtils.write(response_str, fileOutputStream);
	}

	/**
	 * 辅助方法，byte数组保存为本地文件
	 * @param buf
	 * @param buf
	 * @param fileName
	 */
	public static String byte2File(byte[] buf, String fileName) {
		String filePath = "C:\\Users\\Duiba\\Desktop\\";
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file;
		try {
			File dir = new File(filePath);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			file = new File(filePath + File.separator + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(buf);
		}catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(bos != null) {
				try {
					bos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				}catch (IOException e){
					e.printStackTrace();
				}
			}
		}

		return filePath + File.separator + fileName;
	}

}