package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * `order`
 */
@Data
public class Order implements Serializable {
    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("订单创建人")
    private Long createUserId;

    @ApiModelProperty("开单人姓名")
    private String createUserName;

    @ApiModelProperty("开单账号")
    private String createAccount;

    @ApiModelProperty("买家UserId")
    private Long buyerUserId;

    @ApiModelProperty("买家手机号")
    private String buyerMobile;

    @ApiModelProperty("买家名称")
    private String buyerName;

    @ApiModelProperty("卖家UserId")
    private Long sellerUserId;

    @ApiModelProperty("负责人手机号码")
    private String sellerMobile;

    @ApiModelProperty("卖家名称")
    private String sellerName;

    @ApiModelProperty("卖家主体ID")
    private Long signEntityId;

    @ApiModelProperty("卖家主体名称")
    private String entityName;

    @ApiModelProperty("自定义订单编号")
    private String orderNo;

    @ApiModelProperty("订单种类数目")
    private Integer itemCount;

    @ApiModelProperty("货物数量，sum(item*个数)")
    private Integer goodsCount;

    @ApiModelProperty("合同编号")
    private Long contractId;

    @ApiModelProperty("订单原价")
    private BigDecimal originPrice;

    @ApiModelProperty("优惠的价格")
    private BigDecimal reducePrice;

    @ApiModelProperty("实际价格")
    private BigDecimal price;

    @ApiModelProperty("订单状态,0-草稿，1-已发送，2-已完成，3-作废")
    private Byte orderStatus;

    @ApiModelProperty("其他预定事项")
    private String otherDesc;

    @ApiModelProperty("收货地址")
    private String receiveAddress;

}