package cn.com.duiba.youqian.center.api.request.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

@Data
public class AddOrderRequest implements Serializable {

    @NotBlank
    @ApiModelProperty(value = "买家名字", required = true)
    private String buyerName;

    @NotBlank
    @ApiModelProperty(value = "买家手机号", required = true)
    private String phoneNumber;

    @ApiModelProperty(value = "买家公司名", required = true)
    private String companyName;

    @NotBlank
    @ApiModelProperty(value = "订单编号", required = true)
    private String orderNo;

    @NotBlank
    @ApiModelProperty(value = "收货人姓名", required = true)
    private String name;

    @NotBlank
    @ApiModelProperty(value = "收货人手机号", required = true)
    private String mobile;

    @NotBlank
    @ApiModelProperty(value = "收货地址", required = true)
    private String address;

}
