package cn.com.duiba.youqian.center.api.request.order;

import cn.com.duiba.youqian.center.api.request.template.TemplateReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class OrderInfoRequest implements Serializable {

    @NotBlank(message = "买家名字不能为空")
    @ApiModelProperty(value = "买家名字", required = true)
    private String name;

    @NotBlank(message = "卖家ID不能为空")
    @ApiModelProperty(value = "卖家id", required = true)
    private Integer shellUserId;

    @ApiModelProperty(value = "签约主体id", required = true)
    private Integer signEntityId;

    @ApiModelProperty(value = "买家手机号", required = true)
    private String phone;

    @ApiModelProperty(value = "订单原价", required = true)
    private String originPrice;

    @ApiModelProperty(value = "商户ID", required = true)
    private Integer merchantId;

    @ApiModelProperty(value = "组织ID", required = true)
    private Integer orgId;

    @ApiModelProperty(value = "订单种类数目", required = true)
    private String itemCount;

    @ApiModelProperty(value = "货物数量", required = true)
    private String goodsCount;

    @ApiModelProperty(value = "实际价格", required = true)
    private String price;

    @ApiModelProperty(value = "优惠的价格", required = true)
    private String reducePrice;

    @ApiModelProperty(value = "模板ID",required = true)
    private Long templateId;

    @ApiModelProperty(value = "其他预定事项",required = true)
    private String otherDesc;

    @ApiModelProperty(value = "合同参数列表",required = true)
    public List<TemplateReq> tepFieldList;

    @ApiModelProperty(value = "商品列表", required = true)
    private List<GoodsReq> list;
}
