package cn.com.duiba.youqian.center.api.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * 关于时间操作的工具类
 */
public class DateUtil {
    /**
     * 格式 ：yyyy_MM_dd_HH_mm_ss_SSS
     */
    public static final String YYYYMMDDHHMMSSSSS = "yyyy_MM_dd_HH_mm_ss_SSS";
    /**
     * 格式 ：yyyy-MM-dd HH:mm:ss
     */
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    /**
     * 格式 ：yyyy-MM-dd HH:mm
     */
    public static final String YYYYMMDDHHMM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HHMM = "yyyy年MM月dd日 HH:mm";
    /**
     * 格式 ：yyyy-MM-dd
     */
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD = "yyyy年MM月dd日";
    /**
     * 格式 ：MM-dd
     */
    public static final String MMDD = "MM-dd";
    /**
     * 格式 ：HH:mm:ss
     */
    public static final String HHMMSS = "HH:mm:ss";
    /**
     * 格式 ：yyyyMMddHHmmss
     */
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    /**
     * 格式 ：yyyyMMdd
     */
    public static final String yyyyMMdd = "yyyyMMdd";

    /**
     * 格式 ：yyyy年MM月dd日 HH时mm分ss秒
     */
    public static final String YYYYMMDDHHMMSS_CH = "yyyy年MM月dd日 HH时mm分ss秒";
    /**
     * 格式 ：yyyy年MM月dd日
     */
    public static final String YYYYMMDD_CH = "yyyy年MM月dd日";
    /**
     * 格式 ：MM月dd日 hh:mm
     */
    public static final String DATEFORMAT_STR_023 = "MM月dd日 hh:mm";
    /**
     * 后几天的时间戳
     * @param day 天数
     * @return
     */
    public static String nextTimeStamp(int day){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + day);
        System.out.println(calendar.getTimeInMillis());
        return String.valueOf(calendar.getTimeInMillis());
    }

    /**
     * 显示时间间隔
     * 大于一年的 展示 ：年月日
     * 同年：
     * 日期间隔超过1天： 展示 ：月日
     *
     * 同一天：
     * 时间间隔大于1小时的，显示  x小时前
     * 时间间隔小于60分钟的，显示 X分钟前
     * 时间间隔小于60秒的，    显示 刚刚
     * @param longTime
     * @return
     */
    public static String getInterval(String longTime){
        String long_by_13 = "1000000000000";
        String long_by_10 = "1000000000";
        if (Long.valueOf(longTime) / Long.valueOf(long_by_13) < 1) {
            if (Long.valueOf(longTime) / Long.valueOf(long_by_10) >= 1) {
                longTime = longTime + "000";
            }
        }
        Timestamp time = new Timestamp(Long.valueOf(longTime));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long dayConver = 1000 * 60 * 60 * 24;
        long hourConver = 1000 * 60 * 60;
        long minConver = 1000 * 60;
        long timeConver = now.getTime() - time.getTime();
        long tempConver;
        if ((timeConver / dayConver) < 2) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            tempConver = timeConver / dayConver;
            if (tempConver <= 2 && tempConver >= 1) {
                return "昨天" +  format.format(time);
            } else {
                tempConver = (timeConver / hourConver);
                if (tempConver >= 1) {
                    return tempConver + "小时前";
                } else {
                    tempConver = (timeConver / minConver);
                    if (tempConver >= 1) {
                        return tempConver + "分钟前";
                    } else {
                        return "刚刚";
                    }
                }
            }
        } else if((timeConver / dayConver)< 365 ){
            SimpleDateFormat format = new SimpleDateFormat("MM月dd日");
            return format.format(time);
        } else{
            SimpleDateFormat format = new SimpleDateFormat("yyyy年MM月dd日");
            return format.format(time);
        }
    }
}
