/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = null;
    private static Map<String, CloseableHttpClient> httpClients = new HashMap<String, CloseableHttpClient>();
    private static Object o = new Object();

    public static String sendHttpPost(String host, String method, String urlParams, String sendData) {
        String responseString;
        String requestUrl = host + method + urlParams;
        Map<String, Object> response = HttpClientUtil.request("POST", requestUrl, sendData, null);
        int responseCode = Integer.parseInt(response.get("responseCode").toString());
        byte[] responseBytes = (byte[])response.get("responseData");
        try {
            responseString = new String(responseBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            responseString = new String(responseBytes);
        }
        if (responseCode == 200) {
            return responseString;
        }
        return null;
    }

    public static byte[] sendHttpGet(String host, String method, String urlParams) {
        String requestUrl = host + method + urlParams;
        Map<String, Object> response = HttpClientUtil.request("GET", requestUrl, null, null);
        int responseCode = Integer.parseInt(response.get("responseCode").toString());
        byte[] responseBytes = (byte[])response.get("responseData");
        if (responseCode == 200) {
            return responseBytes;
        }
        return null;
    }

    public static String getRedirectUrl(String path) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(path).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(5000);
        return conn.getHeaderField("Location");
    }

    public static String urlencode(String data) {
        return HttpClientUtil.urlencode(data, "UTF-8");
    }

    public static String urlencode(String data, String charset) {
        try {
            return URLEncoder.encode(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Map<String, Object> request(String method, String url, Object sendData, Map<String, String> headers) {
        String requestPath;
        try {
            requestPath = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient(requestPath);
        Map<String, Object> response = null;
        response = "POST".equals(method) ? HttpClientUtil.sendPost(httpClient, url, headers, sendData) : HttpClientUtil.sendGet(httpClient, url, headers);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> sendPost(CloseableHttpClient httpClient, String url, Map<String, String> headers, Object sendData) {
        String tag = "[HttpRequester] [POST " + url + "]";
        int responseCode = -1;
        byte[] responseBytes = null;
        HttpPost request = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (String name : headers.keySet()) {
                String value = headers.get(name);
                request.setHeader(name, value);
            }
        }
        if (sendData != null) {
            StringEntity stringEntity = new StringEntity((String)sendData, "UTF-8");
            stringEntity.setContentType("application/json");
            request.setEntity((HttpEntity)stringEntity);
            HttpEntity httpEntity = null;
            IOException exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                    responseCode = response.getStatusLine().getStatusCode();
                    httpEntity = response.getEntity();
                    String responseBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
                    if (responseBody != null) {
                        responseBytes = responseBody.getBytes();
                    } else {
                        try (InputStream respStream = null;){
                            respStream = httpEntity.getContent();
                            int respBodySize = respStream.available();
                            if (respBodySize <= 0) {
                                // empty if block
                            }
                            if (respStream.read(responseBytes = new byte[respBodySize]) != respBodySize) {
                                // empty if block
                            }
                        }
                    }
                    exception = null;
                    break;
                }
                catch (UnsupportedOperationException e) {
                    try {
                        EntityUtils.consume(httpEntity);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (IOException e) {
                    exception = e;
                    try {
                        EntityUtils.consume(httpEntity);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (i >= 2) continue;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (exception != null) {
                // empty if block
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("responseCode", responseCode);
        response.put("responseData", responseBytes);
        String loggerResponseString = HttpClientUtil.getLoggerString(responseBytes, 256);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> sendGet(CloseableHttpClient httpClient, String url, Map<String, String> headers) {
        String tag = "[HttpRequester] [GET " + url + "]";
        int responseCode = -1;
        byte[] responseBytes = null;
        HttpGet request = new HttpGet(url);
        if (headers != null && headers.size() > 0) {
            for (String name : headers.keySet()) {
                String value = headers.get(name);
                request.setHeader(name, value);
            }
        }
        HttpEntity httpEntity = null;
        IOException exception = null;
        for (int i = 0; i < 3; ++i) {
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                responseCode = response.getStatusLine().getStatusCode();
                httpEntity = response.getEntity();
                byte[] responseBody = EntityUtils.toByteArray((HttpEntity)httpEntity);
                if (responseBody != null) {
                    responseBytes = responseBody;
                } else {
                    try (InputStream respStream = null;){
                        respStream = httpEntity.getContent();
                        int respBodySize = respStream.available();
                        if (respBodySize <= 0) {
                            // empty if block
                        }
                        if (respStream.read(responseBytes = new byte[respBodySize]) != respBodySize) {
                            // empty if block
                        }
                    }
                }
                exception = null;
                break;
            }
            catch (UnsupportedOperationException e) {
                try {
                    EntityUtils.consume(httpEntity);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IOException e) {
                exception = e;
                try {
                    EntityUtils.consume(httpEntity);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (i >= 2) continue;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (exception != null) {
            // empty if block
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("responseCode", responseCode);
        response.put("responseData", responseBytes);
        String loggerResponseString = HttpClientUtil.getLoggerString(responseBytes, 256);
        return response;
    }

    private static String getLoggerString(byte[] data, int maxLength) {
        String loggerString;
        if (data.length > maxLength) {
            byte[] shortData = new byte[maxLength];
            System.arraycopy(data, 0, shortData, 0, shortData.length);
            try {
                loggerString = new String(shortData, "UTF-8") + "...";
            }
            catch (UnsupportedEncodingException e) {
                loggerString = new String(shortData) + "...";
            }
        } else {
            try {
                loggerString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                loggerString = new String(data);
            }
        }
        char[] chars = new char[loggerString.length()];
        loggerString.getChars(0, loggerString.length(), chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != '\n' && c != '\r') continue;
            chars[i] = 32;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloseableHttpClient getHttpClient(String requestPath) {
        Map<String, CloseableHttpClient> map;
        if (httpClients.containsKey(requestPath)) {
            return httpClients.get(requestPath);
        }
        if (poolingHttpClientConnectionManager == null) {
            map = o;
            synchronized (map) {
                if (poolingHttpClientConnectionManager == null) {
                    poolingHttpClientConnectionManager = HttpClientUtils.createHttpClientConnectionManager();
                }
            }
        }
        map = httpClients;
        synchronized (map) {
            if (httpClients.containsKey(requestPath)) {
                return httpClients.get(requestPath);
            }
            CloseableHttpClient httpClient = HttpClientUtils.createHttpClient(poolingHttpClientConnectionManager);
            httpClients.put(requestPath, httpClient);
            return httpClient;
        }
    }

    private static class HttpClientUtils {
        private static int defaultConnectTimeout = 6000;
        private static int defaultReadTimeout = 30000;

        private HttpClientUtils() {
        }

        public static CloseableHttpClient createHttpClient(PoolingHttpClientConnectionManager connManager) {
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).disableContentCompression().setSSLContext(HttpClientUtils.getSslcontext()).setDefaultRequestConfig(HttpClientUtils.getRequestConfig()).build();
            return httpClient;
        }

        public static PoolingHttpClientConnectionManager createHttpClientConnectionManager() {
            SSLConnectionSocketFactory sslConnectionSocketFactory = null;
            try {
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(HttpClientUtils.getSslcontext(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            cm.setMaxTotal(500);
            cm.setDefaultMaxPerRoute(500);
            return cm;
        }

        private static RequestConfig getRequestConfig() {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectionRequestTimeout(defaultConnectTimeout).setSocketTimeout(defaultReadTimeout).build();
            return defaultRequestConfig;
        }

        private static SSLContext getSslcontext() {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                sslContext.init(null, new TrustManager[]{tm}, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return sslContext;
        }
    }
}

