package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * `template_field`
 */
@Data
public class TemplateField implements Serializable {
    @ApiModelProperty("字段ID")
    private Long id;

    @ApiModelProperty("模板ID")
    private Long templateId;

    @ApiModelProperty("字段类目")
    private String fieldCategory;

    @ApiModelProperty("字段名称")
    private String fieldName;

    @ApiModelProperty("字段键值")
    private String fieldKey;

    @ApiModelProperty("字段类型，1-文本/2-日期/3-选择框4/开关")
    private Byte fieldType;

    @ApiModelProperty("是否必填，0-非必填，1-必填")
    private Byte require;

    @ApiModelProperty("提示信息")
    private String placeholder;

    @ApiModelProperty("内容，多个用逗号分隔（如选择框）")
    private String preValue;

    @ApiModelProperty("默认值")
    private String defValue;
}