package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.SmsSendInvoice;
import cn.com.duiba.youqian.center.api.request.common.ScanIdCardRequest;
import cn.com.duiba.youqian.center.api.request.common.ScanIdCardResult;
import cn.com.duiba.youqian.center.api.request.common.ScanLicenseRequest;
import cn.com.duiba.youqian.center.api.request.common.ScanLicenseResult;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description Manage
 */
@AdvancedFeignClient
public interface RemoteCommonService {

    /**
     * 发送验证码
     *
     */
    SmsSendInvoice send(String phone) throws BizException;

    /**
     * OCR扫描身份证
     *
     * @param request request
     * @return ScanIdCardResult
     */
    ScanIdCardResult scanCard(ScanIdCardRequest request) throws BizException;

    /**
     * OCR营业执照
     *
     * @param request request
     * @return ScanLicenseResult
     */
    ScanLicenseResult scanLicense(ScanLicenseRequest request) throws BizException;
}
