package cn.com.duiba.youqian.center.api.request.order;

import cn.com.duiba.youqian.center.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/2/11
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SearchOrderRequest extends PageRequest implements Serializable {
    private static final long serialVersionUID = 3359810351208721462L;

    @ApiModelProperty("订单状态,0-草稿，1-已发送，2-已完成，3-作废")
    private Byte orderStatus;

    @ApiModelProperty("创建时间-开始")
    private Date startCreateTime;

    @ApiModelProperty("创建时间-结束")
    private Date endCreateTime;

    @ApiModelProperty("开单账户")
    private String openAccount;

    @ApiModelProperty("卖方账户")
    private String sellerAccount;

    @ApiModelProperty("买方账户")
    private String buyerAccount;

    @ApiModelProperty(value = "商户ID(前端不用传)")
    private Long merchantId;

    @ApiModelProperty("组织ID(前端不用传)")
    private Long orgId;

    @ApiModelProperty(value = "当前用户ID(前端不用传)", required = true)
    private Long userId;

    @ApiModelProperty(value = "当前用户ID(前端不用传)")
    private Boolean entOrderPermission;
}
