package cn.com.duiba.youqian.center.api.result.order;

import cn.com.duiba.youqian.center.api.entity.Order;
import cn.com.duiba.youqian.center.api.entity.OrderItem;
import cn.com.duiba.youqian.center.api.entity.TemplateValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/2/11
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderDetail extends Order implements Serializable {
    private static final long serialVersionUID = -1083504716025464480L;

    @ApiModelProperty("订单项")
    private List<OrderItem> orderItemList;

    @ApiModelProperty("模板信息")
    private List<TemplateValue> fieldList;

    @ApiModelProperty("合同预览地址")
    private String contractPreviewUrl;

    @ApiModelProperty("合同下载地址")
    private String contractDownloadUrl;
}
